<!doctype html>
<html lang="pt-br">

<head>
    <meta charset="utf-8">
    <title>Leads</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="https://qa-uploads.madnezz.com.br/7b16377ebd9c1744775e55fc6bb8a046" />
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css" rel="stylesheet">
</head>

<body>
    <div class="page">
        <header class="brandbar">
            <div class="container-fluid px-2 px-md-3">
                <div class="d-flex flex-column flex-md-row align-items-start align-items-md-center justify-content-between gap-2">
                    <div class="d-flex align-items-center gap-3 flex-column flex-sm-row">
                        <img src="https://qa-uploads.madnezz.com.br/f1eb249d7256d2cf08e05ed72a50a510" alt="Madnezz" class="logo">
                        <div class="title">
                            <div class="fw-semibold">Revisão de Leads</div>
                        </div>
                    </div>



                    <div id="brandbar" class="w-100 w-md-auto">
                        <div class="d-flex flex-wrap justify-content-start justify-content-md-end align-items-center gap-2">
                            <span class="badge rounded-pill badge-soft" id="rowCountBadge">
                                Total de Leads: <span id="rowCountValue">0</span>
                            </span>

                            <button id="btnAtualizar" class="btn btn-outline-primary btn-sm ms-md-2">
                                Atualizar dados
                            </button>

                            <button id="btnExportFiltrado" class="btn btn-success btn-sm ms-md-2">
                                Exportar Filtrado (Excel)
                            </button>

                            <button id="btnExportTudo" class="btn btn-secondary btn-sm ms-md-2">
                                Exportar Tudo (Excel)
                            </button>


                            <span id="statusAtualizacao" class="ms-0 ms-md-2 text-muted d-flex align-items-center" style="display:none;">
                                <span class="spinner-border spinner-border-sm me-1" role="status"
                                    aria-hidden="true"></span>
                                Buscando novas atualizações...
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <main class="content">
            <div class="container-fluid px-2 px-md-3">
                <div id="alertContainer" class="mb-3"></div>

                <!-- CARD LEADS -->
                <div class="card mb-4">
                    <div class="card-body">
                        <h5 class="mb-3">Relatório de Leads</h5>
                        <div class="table-container table-responsive">
                            <table id="gridLeads" class="table table-striped table-hover align-middle">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Nome</th>
                                        <th>Email</th>
                                        <th>Telefone</th>

                                        <th>Estado</th>
                                        <th>Região</th>
                                        <th>Formato</th>
                                        <th>Segmento</th>
                                        <th>Segmento Descrição</th>

                                        <th>Executivo</th>
                                        <th>Supervisor</th>
                                        <th>Equipe</th>

                                        <th>Status</th>

                                        <th>Origem</th>
                                        <th>Origem ID</th>
                                        <th>Completed</th>
                                        <th>Enviado</th>
                                        <th>Confirmado Em</th>
                                        <th>SLA Status</th>

                                        <th>Criado Em</th>
                                        <th>Atualizado Em</th>
                                    </tr>
                                </thead>

                                <tbody></tbody>

                                <tfoot>
                                    <tr>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar ID"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Nome"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Email"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Telefone"></th>

                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Estado"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Região"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Formato"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Segmento"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Segmento Desc"></th>

                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Executivo"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Supervisor"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Equipe"></th>

                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Status"></th>

                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Origem"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Origem ID"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Completed"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Enviado"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Confirmado"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar SLA"></th>

                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Criado"></th>
                                        <th><input class="form-control form-control-sm" placeholder="Filtrar Atualizado"></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </main>

        <footer class="footer mt-auto">
            <div class="container-fluid px-2 px-md-3 text-center py-2 text-muted small">
                © Madnezz 2025
            </div>
            <div id="lastUpdated" class="text-muted small">
                Atualizado em: --
            </div>
        </footer>
    </div>

    <style>
        footer.footer {
            border-top: 1px solid #e5e7eb;
            background: #ffffff;
            text-align: center;
            font-size: 0.85rem;
            color: #6b7280;
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/xlsx/dist/xlsx.full.min.js"></script>
    <script type="text/javascript" src="assets/js/script.js"></script>
</body>

</html>