// ===============================================
//   CONFIG DA API
// ===============================================
const API_URL = "assets/inc/proxy-leads.php";
const API_KEY = "b5JZslEMQ3iNiJwy7Me5HZVXMaUc8NWD";

const KEYS_LEADS = [
  "id",
  "name",
  "email",
  "phone",

  "estado",
  "regiao",
  "formato",
  "segmento",
  "segmento_descricao",

  "executivo",
  "supervisor",
  "equipe",

  "status",

  "origem",
  "origem_id",
  "completed",
  "enviado",
  "confirmado_em",
  "sla_status",

  "created_at",
  "updated_at"
];


// ===============================================
//   DATATABLES (inicializa uma única vez)
// ===============================================
let dataTable = null;

function initDataTableOnce() {
  if (dataTable) return;

  dataTable = $("#gridLeads").DataTable({
    order: [],
    pageLength: 25,
    lengthMenu: [
      [25, 50, 100, -1],
      [25, 50, 100, "TUDO"]
    ],
    language: {
      url: "https://cdn.datatables.net/plug-ins/1.13.8/i18n/pt-BR.json"
    },
    initComplete: function () {
      this.api().columns().every(function () {
        const that = this;
        $("input", this.footer()).on("keyup change clear", function () {
          if (that.search() !== this.value) {
            that.search(this.value).draw();
          }
        });
      });
    }
  });
}

// ===============================================
//   INSERIR UMA LINHA NA TABELA (incremental)
// ===============================================
function addLeadRow(item) {
  if (!dataTable) return;

  const row = KEYS_LEADS.map(key => {
    switch (key) {
      case "estado":
        return item.estado?.value || "";
      case "regiao":
        return item.regiao?.value || "";
      case "formato":
        return item.formato?.value || "";
      case "segmento":
        return item.segmento?.value || "";
      case "executivo":
        return item.executivo?.name || "";
      case "supervisor":
        return item.supervisor?.name || "";
      case "equipe":
        return item.equipe?.name || "";
      case "status":
        return item.status?.value || "";
      default:
        return item[key] ?? "";
    }
  });

  dataTable.row.add(row).draw(false);
}


// ===============================================
//   ALERTA
// ===============================================
function addAlert(msg) {
  $("#alertContainer").append(`
      <div class="alert alert-warning m-0 mb-2" role="alert"
           style="background:#fff7ed; color:#9a3412; border:1px solid #fed7aa;">
          ${msg}
      </div>
  `);
}

// ===============================================
//   BUSCA INCREMENTAL (STREAMING)
// ===============================================
async function fetchLeadsStreaming() {
  let page = 1;
  let lastPage = 1;
  let total = 0;

  // Tela limpa
  if (dataTable) {
    dataTable.clear().draw();
  }

  while (page <= lastPage) {
    const url = `${API_URL}?per_page=100&page=${page}&order_by=created_at&order_direction=desc`;

    const response = await fetch(url, {
      headers: {
        "Accept": "application/json",
        "x-api-key": API_KEY
      }
    });

    if (!response.ok) {
      addAlert(`Erro ao carregar página ${page} (HTTP ${response.status})`);
      break;
    }

    const json = await response.json();

    // Inicia DataTable quando chega a primeira página
    if (page === 1) {
      initDataTableOnce();
    }

    if (json.data) {
      json.data.forEach(item => {
        addLeadRow(item);
        total++;
      });
    }

    if (json.meta) {
      lastPage = json.meta.last_page;
    }

    updateBadge(total);
    page++;
  }
}

// ===============================================
//   BADGE
// ===============================================
function updateBadge(total) {
  $("#rowCountValue").text(total.toLocaleString("pt-BR"));
}

// ===============================================
//   CARREGAR TUDO
// ===============================================
async function carregarTudo() {
  $("#statusAtualizacao").show();
  $("#alertContainer").empty();

  try {
    await fetchLeadsStreaming();
  } finally {
    $("#statusAtualizacao").hide();

    const agora = new Date();
    $("#lastUpdated").text(
      `Atualizado em: ${agora.toLocaleDateString("pt-BR")} ${agora.toLocaleTimeString("pt-BR")}`
    );
  }
}

// ===============================================
//   INIT
// ===============================================
$(document).ready(function () {
  carregarTudo();

  $("#btnAtualizar").on("click", function () {
    carregarTudo();
  });
});


function exportarFiltradoExcel() {
  if (!dataTable) return;

  // Pega apenas as linhas visíveis (filtradas)
  const data = dataTable.rows({
    search: 'applied'
  }).data().toArray();

  // Converte para JSON estruturado
  const json = data.map(row => {
    let obj = {};
    KEYS_LEADS.forEach((key, i) => {
      obj[key] = row[i];
    });
    return obj;
  });

  const ws = XLSX.utils.json_to_sheet(json);
  const wb = XLSX.utils.book_new();
  XLSX.utils.book_append_sheet(wb, ws, "Filtrado");

  XLSX.writeFile(wb, "leads_filtrados.xlsx");
}


async function exportarTudoExcel() {
  // vai buscar tudo direto da API, independentemente do filtro
  let page = 1;
  let lastPage = 1;
  let results = [];

  while (page <= lastPage) {
    const url = `${API_URL}?per_page=100&page=${page}&order_by=created_at&order_direction=desc`;

    const response = await fetch(url, {
      headers: {
        "Accept": "application/json",
        "x-api-key": API_KEY
      }
    });

    if (!response.ok) {
      alert("Erro ao buscar dados completos.");
      return;
    }

    const json = await response.json();

    if (json.data) results = results.concat(json.data);

    if (json.meta) lastPage = json.meta.last_page;

    page++;
  }

  // preparar para excel
  const jsonReady = results.map(item => {
    let obj = {};

    KEYS_LEADS.forEach(key => {
      switch (key) {
        case "estado":
          obj[key] = item.estado?.value || "";
          break;
        case "regiao":
          obj[key] = item.regiao?.value || "";
          break;
        case "formato":
          obj[key] = item.formato?.value || "";
          break;
        case "segmento":
          obj[key] = item.segmento?.value || "";
          break;
        case "executivo":
          obj[key] = item.executivo?.name || "";
          break;
        case "supervisor":
          obj[key] = item.supervisor?.name || "";
          break;
        case "equipe":
          obj[key] = item.equipe?.name || "";
          break;
        case "status":
          obj[key] = item.status?.value || "";
          break;
        default:
          obj[key] = item[key] ?? "";
      }
    });

    return obj;
  });

  const ws = XLSX.utils.json_to_sheet(jsonReady);
  const wb = XLSX.utils.book_new();
  XLSX.utils.book_append_sheet(wb, ws, "Tudo");

  XLSX.writeFile(wb, "leads_completo.xlsx");
}


$("#btnExportFiltrado").on("click", exportarFiltradoExcel);
$("#btnExportTudo").on("click", exportarTudoExcel);
