$(function () {
  const datax = new Date();
  const year  = datax.getFullYear();

  // 1) Garante container com a classe usada no Swiper
  // (se seu HTML já tiver .news-swiper, essa linha não atrapalha)
  $('.swiper-container.black-move.swiper-pagination-bottom').addClass('news-swiper');

  // 2) shopping_id seguro
  const shopping_id = 192

  // 3) destrói Swiper anterior, se existir
  if (window.__newsSwiperInstance && typeof window.__newsSwiperInstance.destroy === 'function') {
    window.__newsSwiperInstance.destroy(true, true);
    window.__newsSwiperInstance = null;
  }

  // 4) função para buscar (tenta JSONP com o nome do parâmetro informado)
  function fetchNews(jsonpParamName) {
    return $.ajax({
      url: 'https://sal.madnezz.com.br/api/site/json/novidade.asp',
      dataType: 'jsonp',
      jsonp: jsonpParamName,     // 'callback' ou 'jsoncallback'
      data: { tp: 5, ano: year, shopping_id: shopping_id },
      timeout: 15000,
      crossDomain: true
    });
  }

  // 5) renderiza os slides e inicializa o Swiper
    // ... seu código acima permanece igual até a função renderNews ...

    function renderNews(data) {
  if (!Array.isArray(data) || !data.length) return;

  const $list = $('.novidade_lista').empty();

  data.slice(0, 6).forEach(function (novidade) {
    const nome = (novidade.novidade_nome || '').trim();
    const titulo50 = (nome.length > 50) ? (nome.substring(0, 50) + '…') : nome;

    const imgSrc = novidade.novidade_imagem_1
      ? 'https://sal.madnezz.com.br/api/site/upload/acontece/' + encodeURIComponent(novidade.novidade_imagem_1)
      : 'https://upload.madnezz.com.br/060d19e41650e4c29d49b6b793dd4f4a';

    const texto = (novidade.novidade_texto || '').replace(/<\/?[^>]+(>|$)/g, '');
    const descricao = texto.length > 150 ? (texto.substring(0, 150) + '…') : texto;

    const link = 'noticias.php?noticia_id=' + encodeURIComponent(novidade.novidade_id || '');

    $list.append(
      '<li class="swiper-slide novidade_' + (novidade.novidade_id || '') + '">' +
        '<article class="news-card">' +

          // IMAGEM QUADRADA e ALT com nome da notícia
          '<a class="news-card__image-wrap" href="' + link + '">' +
            '<img src="' + imgSrc + '" alt="' + (nome || 'Notícia') + '">' +
          '</a>' +

          // TEXTO
          '<div class="news-card__body">' +
            '<h3 class="news-card__title">' + titulo50 + '</h3>' +
            '<p class="news-card__excerpt">' + descricao + '</p>' +
            // CTA PILL
            '<a class="cta-pill" href="' + link + '">Leia mais</a>' +
          '</div>' +

        '</article>' +
      '</li>'
    );
  });

  // inicia Swiper (sem bullets)
  if (window.__newsSwiperInstance && typeof window.__newsSwiperInstance.destroy === 'function') {
    window.__newsSwiperInstance.destroy(true, true);
  }

        window.__newsSwiperInstance = new Swiper('.news-swiper', {
        slidesPerView: 3,
        centeredSlides: false,
        loop: false,
        spaceBetween: 12,           
        speed: 900,
        autoplay: { delay: 7000, disableOnInteraction: false },
        navigation: {
            nextEl: '.swiper-button-next-nav',
            prevEl: '.swiper-button-previous-nav'
        },
        keyboard: { enabled: true, onlyInViewport: true },
        breakpoints: {
            1400: { slidesPerView: 3, spaceBetween: 14, centeredSlides: false },
            1200: { slidesPerView: 3, spaceBetween: 12, centeredSlides: false },
            992:  { slidesPerView: 3, spaceBetween: 12, centeredSlides: false }, 
            768:  { slidesPerView: 2, spaceBetween: 10, centeredSlides: false },
            480:  { slidesPerView: 1, spaceBetween: 8,  centeredSlides: false },
            320:  { slidesPerView: 1, spaceBetween: 8,  centeredSlides: false }
        },
        effect: 'slide'
        });


}

  fetchNews('callback')
    .done(renderNews)
    .fail(function (xhr, status) {
      console.warn('News JSONP falhou com "callback". Tentando "jsoncallback"...', xhr && xhr.status);

      fetchNews('jsoncallback')
        .done(renderNews)
        .fail(function (xhr2) {
          console.warn('Falha ao carregar novidades', xhr2 && xhr2.status);
        });
    });
});
