  $(document).ready(function () {
      var isDragging = false;
      var startX, startY;
      var scrollLeft, scrollTop;
      var $container = $('.timeline');
      var $img = $container.find('img');

      function startDrag(e) {
          isDragging = true;
          startX = e.pageX || e.originalEvent.touches[0].pageX;
          startY = e.pageY || e.originalEvent.touches[0].pageY;
          scrollLeft = $container.scrollLeft();
          scrollTop = $container.scrollTop();
          $container.css('cursor', 'grabbing');
      }

      function duringDrag(e) {
          if (!isDragging) return;
          var moveX = (e.pageX || e.originalEvent.touches[0].pageX) - startX;
          var moveY = (e.pageY || e.originalEvent.touches[0].pageY) - startY;

          $container.scrollLeft(scrollLeft - moveX);
          $container.scrollTop(scrollTop - moveY);
      }

      function stopDrag() {
          isDragging = false;
          $container.css('cursor', 'grab');
      }
      $container.on('mousedown touchstart', startDrag);
      $container.on('mousemove touchmove', duringDrag);
      $(document).on('mouseup touchend', stopDrag);
      $container.on('dragstart', function (e) {
          e.preventDefault();
      });
  });